package shooting;

import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.ItemType;
import java.util.ArrayList;
import java.util.logging.Logger;

public class WeaponStats {
    private int firstDamagePerShot;
    private int secondDamagePerShot;
    /*
     * Definition of speed is rather weird: it means what distance it will
     * pass in one doLogic() cycle. Although this can vary, because Predictor
     * uses information stepped by this cycle as well (reads last positions
     * entered in the same cycles), the relative speed estimation is correct
     */
    private double firstSpeed;
    private double secondSpeed;
    private int firstDamagePerCycle;
    private int secondDamagePerCycle;
    private double firstMinimalDistance;
    private double secondMinimalDistance;
    private double firstOptimalDistance;
    private double secondOptimalDistance;
    private double firstMaximalDistance;
    private double secondMaximalDistance;
    private int lowAmmo;
    private int lowAlternativeAmmo;
   
    public final static WeaponStats FlakCannonStats;
    public final static WeaponStats RocketLauncherStats;
    public final static WeaponStats ShockRifleStats;
    public final static WeaponStats AssaultRifleStats;
    public final static WeaponStats BioRifleStats;
    public final static WeaponStats ShieldGunStats;
    public final static WeaponStats LighteningGunStats;
    public final static WeaponStats LinkGunStats;
    public final static WeaponStats MinigunStats;
    
    static {
        /*** These values were set after some testing - they can be adjusted,
             if prove wrong ***/
        AssaultRifleStats = new WeaponStats(     7,  70, 11, 15, 100000,    220,   0, 100,  500, 1000, 2000, 3000, 40,  2);
        BioRifleStats = new WeaponStats(        37, 200, 28, 25,    240,    120, 100, 300,  500,  600, 1500, 1000,  7, 10);
        FlakCannonStats = new WeaponStats(      60, 120, 12, 18,    320,    150, 200, 200,  500,  800, 1500, 2000,  5,  5);
        RocketLauncherStats = new WeaponStats(  88, 150, 15, 10,    200,    200, 100, 100, 1000, 1200, 3000, 4000,  4,  6);
        LighteningGunStats = new WeaponStats(   70,   0,  7,  0, 100000,      0,   0,   0, 2000,    0, 9000,    0,  4,  0);
        LinkGunStats = new WeaponStats(         30,   9, 20, 18,   2000, 100000,   0,   0, 1600,  600, 4000, 1000, 30, 30);
        MinigunStats = new WeaponStats(          7,  15, 14, 15,   4000,   4000,   0,   0,  900, 1500, 2500, 3000, 40, 20);
        ShieldGunStats = new WeaponStats(       40,   0,  7,  0, 100000,      0,   0,   0,  100,    0,  130, 9000,  0, 20);
        ShockRifleStats = new WeaponStats(      45,  38, 10, 13, 100000,    155,   0, 100, 2000, 1000, 9000, 4000,  4,  6);
    }
    
    public static WeaponStats getWeaponStats(ItemType type) {
        switch (type) {
            case ASSAULT_RIFLE:
                return AssaultRifleStats;
            case BIO_RIFLE:
                return BioRifleStats;
            case FLAK_CANNON:
                return FlakCannonStats;
            case LIGHTNING_GUN:
                return LighteningGunStats;
            case LINK_GUN:
                return LinkGunStats;
            case MINIGUN:
                return MinigunStats;
            case ROCKET_LAUNCHER:
                return RocketLauncherStats;
            case SHIELD_GUN:
                return ShieldGunStats;
            case SHOCK_RIFLE:
                return ShockRifleStats;
        }
        return null;
    }

    public static AddWeaponMode getBestWeapon(Triple myLoc, Triple enemyLoc, ArrayList<AddWeapon> possible, Logger log) {
        AddWeapon best = null;
        int maxscore = 0;
        boolean alternative = false;
        double distance = Triple.distanceInSpace(myLoc, enemyLoc);
        for (AddWeapon w: possible) {
            int fscore = 0, sscore = 0;
            WeaponStats ws = getWeaponStats(w.getWeaponType());
            if (ws == null) continue;
            double ratio;
            if (w.currentAmmo > 0 && distance >= ws.firstMinimalDistance && distance <= ws.firstMaximalDistance) {
                if (distance > ws.firstOptimalDistance) {
                    ratio = ws.firstOptimalDistance/distance;
                } else {
                    ratio = (ws.firstOptimalDistance - distance)/ws.firstOptimalDistance;
                }
                fscore = (int) (ratio*(ws.firstDamagePerShot + 5*ws.firstDamagePerCycle));
            }
            if (w.currentAltAmmo > 0 && distance >= ws.secondMinimalDistance && distance <= ws.secondMaximalDistance) {
                if (distance > ws.secondOptimalDistance) {
                    ratio = ws.secondOptimalDistance/distance;
                } else {
                    ratio = (ws.secondOptimalDistance - distance)/ws.secondOptimalDistance;
                }
                sscore = (int) (ratio*(ws.secondDamagePerShot + 5*ws.secondDamagePerCycle));
            }
            if (fscore > maxscore) {
                maxscore = fscore;
                alternative = false;
                best = w;
            }
            if (sscore > maxscore) {
                maxscore = sscore;
                alternative = true;
                best = w;
            }
        }
        return new AddWeaponMode(best, alternative);
    }
    
    public double getFirstMaximalDistance() {
        return firstMaximalDistance;
    }

    public double getFirstMinimalDistance() {
        return firstMinimalDistance;
    }

    public double getFirstOptimalDistance() {
        return firstOptimalDistance;
    }

    public double getFirstSpeed() {
        return firstSpeed;
    }

    public double getSecondMaximalDistance() {
        return secondMaximalDistance;
    }

    public double getSecondMinimalDistance() {
        return secondMinimalDistance;
    }

    public double getSecondOptimalDistance() {
        return secondOptimalDistance;
    }

    public double getSecondSpeed() {
        return secondSpeed;
    }
    
    public int getLowAmmo() {
        return lowAmmo;
    }
    
    public int getLowAlternativeAmmo() {
        return lowAlternativeAmmo;
    }
    
    private WeaponStats(int fd, int sd, int fdc, int sdc, double fs, double ss,
            double fmin, double smin, double fopt, double sopt, double fmax, double smax, int lowa, int lowaa) {
        firstDamagePerShot = fd;
        secondDamagePerShot = sd;
        firstDamagePerCycle = fdc;
        secondDamagePerCycle = sdc;
        firstSpeed = fs;
        secondSpeed = ss;
        firstMinimalDistance = fmin;
        secondMinimalDistance = smin;
        firstOptimalDistance = fopt;
        secondOptimalDistance = sopt;
        firstMaximalDistance = fmax;
        secondMaximalDistance = smax;
        lowAmmo = lowa;
        lowAlternativeAmmo = lowaa;
    }

    public int getFirstDamagePerCycle() {
        return firstDamagePerCycle;
    }

    public int getFirstDamagePerShot() {
        return firstDamagePerShot;
    }

    public int getSecondDamagePerCycle() {
        return secondDamagePerCycle;
    }

    public int getSecondDamagePerShot() {
        return secondDamagePerShot;
    }
}